/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.recipe;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemHandlerHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2444;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_7923;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.recipe.helper.LoggingRecipeSerializer;
import slimeknights.mantle.recipe.ingredient.SizedIngredient;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.json.predicate.modifier.ModifierPredicate;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.recipe.ITinkerableContainer;
import slimeknights.tconstruct.library.recipe.RecipeResult;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierRecipeLookup;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierSalvage;
import slimeknights.tconstruct.library.recipe.modifiers.adding.ModifierRecipe;
import slimeknights.tconstruct.library.recipe.tinkerstation.ValidatedResult;
import slimeknights.tconstruct.library.recipe.worktable.AbstractSizedIngredientRecipeBuilder;
import slimeknights.tconstruct.library.recipe.worktable.AbstractWorktableRecipe;
import slimeknights.tconstruct.library.tools.item.IModifiableDisplay;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.utils.JsonUtils;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class ModifierRemovalRecipe
extends AbstractWorktableRecipe {
    private static final class_2561 TITLE = TConstruct.makeTranslation("recipe", "remove_modifier.title");
    private static final class_2561 DESCRIPTION = TConstruct.makeTranslation("recipe", "remove_modifier.description");
    private static final class_2561 NO_MODIFIERS = TConstruct.makeTranslation("recipe", "remove_modifier.no_modifiers");
    private final SizedIngredient sizedTool;
    private final List<class_1799> leftovers;
    private final IJsonPredicate<ModifierId> modifierPredicate;
    protected final Predicate<ModifierEntry> entryPredicate;
    private List<ModifierEntry> displayModifiers;

    public ModifierRemovalRecipe(class_2960 id, SizedIngredient toolRequirement, List<SizedIngredient> inputs, List<class_1799> leftovers, IJsonPredicate<ModifierId> modifierPredicate) {
        super(id, class_1856.field_9017, inputs);
        this.sizedTool = toolRequirement;
        this.leftovers = leftovers;
        this.modifierPredicate = modifierPredicate;
        this.entryPredicate = mod -> modifierPredicate.matches(mod.getId());
    }

    @Deprecated
    public ModifierRemovalRecipe(class_2960 id, List<SizedIngredient> inputs, List<class_1799> leftovers, IJsonPredicate<ModifierId> modifierPredicate) {
        this(id, SizedIngredient.fromTag(TinkerTags.Items.MODIFIABLE), inputs, leftovers, modifierPredicate);
    }

    @Deprecated
    public ModifierRemovalRecipe(class_2960 id, List<SizedIngredient> inputs, List<class_1799> leftovers) {
        this(id, inputs, leftovers, ModifierPredicate.ALWAYS);
    }

    @Override
    public class_2561 getTitle() {
        return TITLE;
    }

    @Override
    public boolean matches(ITinkerableContainer inv, class_1937 world) {
        if (!this.sizedTool.test(inv.getTinkerableStack())) {
            return false;
        }
        return ModifierRecipe.checkMatch(inv, this.inputs);
    }

    protected List<ModifierEntry> filter(@Nullable IToolStackView tool, List<ModifierEntry> modifiers) {
        if (this.modifierPredicate != ModifierPredicate.ALWAYS) {
            return modifiers.stream().filter(this.entryPredicate).toList();
        }
        return modifiers;
    }

    @Override
    public List<ModifierEntry> getModifierOptions(@Nullable ITinkerableContainer inv) {
        if (inv == null) {
            if (this.displayModifiers == null) {
                this.displayModifiers = this.filter(null, ModifierRecipeLookup.getRecipeModifierList());
            }
            return this.displayModifiers;
        }
        return this.filter(inv.getTinkerable(), inv.getTinkerable().getUpgrades().getModifiers());
    }

    @Override
    public class_2561 getDescription(@Nullable ITinkerableContainer inv) {
        if (inv != null && inv.getTinkerable().getUpgrades().getModifiers().stream().noneMatch(this.entryPredicate)) {
            return NO_MODIFIERS;
        }
        return DESCRIPTION;
    }

    @Override
    public RecipeResult<ToolStack> getResult(ITinkerableContainer inv, ModifierEntry entry) {
        ToolStack tool = inv.getTinkerable();
        tool = tool.copy();
        ModifierId modifierId = entry.getId();
        ModifierSalvage salvage = ModifierRecipeLookup.getSalvage(inv.getTinkerableStack(), tool, modifierId, entry.getLevel());
        if (salvage != null) {
            salvage.updateTool(tool);
        }
        int newLevel = tool.getModifierLevel(modifierId) - 1;
        Modifier modifier = entry.getModifier();
        if (newLevel <= 0) {
            modifier.getHook(TinkerHooks.RAW_DATA).removeRawData(tool, modifier, tool.getRestrictedNBT());
        }
        tool.removeModifier(modifierId, 1);
        class_2561 error = tool.tryValidate();
        if (error != null) {
            return RecipeResult.failure(error);
        }
        if (newLevel <= 0 && (error = modifier.getHook(TinkerHooks.REMOVE).onRemoved(tool, modifier)) != null) {
            return RecipeResult.failure(error);
        }
        ValidatedResult validated = ModifierRecipeLookup.checkRequirements(inv.getTinkerableStack(), tool);
        if (validated.hasError()) {
            return RecipeResult.failure(validated.getMessage());
        }
        return RecipeResult.success(tool);
    }

    @Override
    public int toolResultSize() {
        return 64;
    }

    @Override
    public void updateInputs(IToolStackView result, ITinkerableContainer.Mutable inv, boolean isServer) {
        super.updateInputs(result, inv, isServer);
        if (isServer) {
            for (class_1799 stack : this.leftovers) {
                inv.giveItem(stack.method_7972());
            }
        }
    }

    public class_1865<?> method_8119() {
        return (class_1865)TinkerModifiers.removeModifierSerializer.get();
    }

    @Override
    public List<class_1799> getInputTools() {
        if (this.tools == null) {
            this.tools = this.sizedTool.getMatchingStacks().stream().map(stack -> {
                class_1799 tool = IModifiableDisplay.getDisplayStack(stack.method_7909());
                if (stack.method_7947() > 1) {
                    tool = ItemHandlerHelper.copyStackWithSize((class_1799)tool, (int)stack.method_7947());
                }
                return tool;
            }).toList();
        }
        return this.tools;
    }

    public static class Builder
    extends AbstractSizedIngredientRecipeBuilder<Builder> {
        private final class_1865<? extends ModifierRemovalRecipe> serializer;
        private final List<class_1799> leftovers = new ArrayList<class_1799>();
        private SizedIngredient tools = SizedIngredient.EMPTY;
        private IJsonPredicate<ModifierId> modifierPredicate = ModifierPredicate.ALWAYS;

        public static Builder removal() {
            return Builder.removal((class_1865<? extends ModifierRemovalRecipe>)((class_1865)TinkerModifiers.removeModifierSerializer.get()));
        }

        public Builder setTools(SizedIngredient ingredient) {
            this.tools = ingredient;
            return this;
        }

        public Builder setTools(class_1856 ingredient) {
            return this.setTools(SizedIngredient.of(ingredient));
        }

        public Builder addLeftover(class_1799 stack) {
            this.leftovers.add(stack);
            return this;
        }

        public Builder addLeftover(class_1935 item) {
            return this.addLeftover(new class_1799(item));
        }

        @Override
        public void save(Consumer<class_2444> consumer) {
            this.save(consumer, class_7923.field_41178.method_10221((Object)this.leftovers.get(0).method_7909()));
        }

        @Override
        public void save(Consumer<class_2444> consumer, class_2960 id) {
            if (this.inputs.isEmpty()) {
                throw new IllegalStateException("Must have at least one input");
            }
            class_2960 advancementId = this.buildOptionalAdvancement(id, "modifiers");
            consumer.accept(new Finished(id, advancementId));
        }

        private Builder(class_1865<? extends ModifierRemovalRecipe> serializer) {
            this.serializer = serializer;
        }

        public static Builder removal(class_1865<? extends ModifierRemovalRecipe> serializer) {
            return new Builder(serializer);
        }

        public Builder modifierPredicate(IJsonPredicate<ModifierId> modifierPredicate) {
            this.modifierPredicate = modifierPredicate;
            return this;
        }

        private class Finished
        extends AbstractSizedIngredientRecipeBuilder.SizedFinishedRecipe {
            public Finished(@Nullable class_2960 ID, class_2960 advancementID) {
                super(ID, advancementID);
            }

            @Override
            public void method_10416(JsonObject json) {
                super.method_10416(json);
                SizedIngredient ingredient = Builder.this.tools;
                if (ingredient == SizedIngredient.EMPTY) {
                    ingredient = SizedIngredient.fromTag(TinkerTags.Items.MODIFIABLE);
                }
                json.add("tools", (JsonElement)ingredient.serialize());
                if (!Builder.this.leftovers.isEmpty()) {
                    JsonArray array = new JsonArray();
                    for (class_1799 stack : Builder.this.leftovers) {
                        array.add(JsonUtils.serializeItemStack(stack));
                    }
                    json.add("leftovers", (JsonElement)array);
                }
                json.add("modifier_predicate", ModifierPredicate.LOADER.serialize(Builder.this.modifierPredicate));
            }

            public class_1865<?> method_17800() {
                return Builder.this.serializer;
            }
        }
    }

    public static class Serializer
    extends LoggingRecipeSerializer<ModifierRemovalRecipe> {
        private final Factory factory;

        @Deprecated
        public Serializer(ModifierRemovalRecipeFactory factory) {
            this((Factory)factory);
        }

        public ModifierRemovalRecipe fromJson(class_2960 id, JsonObject json) {
            SizedIngredient tool = json.has("tools") ? SizedIngredient.deserialize(class_3518.method_15296((JsonObject)json, (String)"tools")) : SizedIngredient.fromTag(TinkerTags.Items.MODIFIABLE);
            List<SizedIngredient> ingredients = JsonHelper.parseList(json, "inputs", SizedIngredient::deserialize);
            List<class_1799> leftovers = Collections.emptyList();
            if (json.has("leftovers")) {
                leftovers = JsonHelper.parseList(json, "leftovers", JsonUtils::convertToItemStack);
            }
            IJsonPredicate<ModifierId> modifierPredicate = ModifierPredicate.ALWAYS;
            if (json.has("modifier_predicate")) {
                modifierPredicate = ModifierPredicate.LOADER.getAndDeserialize(json, "modifier_predicate");
            }
            return this.factory.create(id, tool, ingredients, leftovers, modifierPredicate);
        }

        @Override
        @Nullable
        public ModifierRemovalRecipe fromNetworkSafe(class_2960 id, class_2540 buffer) {
            SizedIngredient tool = SizedIngredient.read(buffer);
            int size = buffer.method_10816();
            ImmutableList.Builder ingredients = ImmutableList.builder();
            for (int i = 0; i < size; ++i) {
                ingredients.add((Object)SizedIngredient.read(buffer));
            }
            size = buffer.method_10816();
            ImmutableList.Builder leftovers = ImmutableList.builder();
            for (int i = 0; i < size; ++i) {
                leftovers.add((Object)buffer.method_10819());
            }
            IJsonPredicate<ModifierId> modifierPredicate = ModifierPredicate.LOADER.fromNetwork(buffer);
            return this.factory.create(id, tool, (List<SizedIngredient>)ingredients.build(), (List<class_1799>)leftovers.build(), modifierPredicate);
        }

        @Override
        public void toNetworkSafe(class_2540 buffer, ModifierRemovalRecipe recipe) {
            recipe.sizedTool.write(buffer);
            buffer.method_10804(recipe.inputs.size());
            for (SizedIngredient ingredient : recipe.inputs) {
                ingredient.write(buffer);
            }
            buffer.method_10804(recipe.leftovers.size());
            for (class_1799 itemStack : recipe.leftovers) {
                buffer.method_10793(itemStack);
            }
            ModifierPredicate.LOADER.toNetwork(recipe.modifierPredicate, buffer);
        }

        public Serializer(Factory factory) {
            this.factory = factory;
        }
    }

    @FunctionalInterface
    public static interface Factory {
        public ModifierRemovalRecipe create(class_2960 var1, SizedIngredient var2, List<SizedIngredient> var3, List<class_1799> var4, IJsonPredicate<ModifierId> var5);
    }

    @Deprecated
    @FunctionalInterface
    public static interface ModifierRemovalRecipeFactory
    extends Factory {
        public ModifierRemovalRecipe create(class_2960 var1, List<SizedIngredient> var2, List<class_1799> var3, IJsonPredicate<ModifierId> var4);

        @Override
        default public ModifierRemovalRecipe create(class_2960 id, SizedIngredient toolRequirement, List<SizedIngredient> inputs, List<class_1799> leftovers, IJsonPredicate<ModifierId> modifierPredicate) {
            return this.create(id, inputs, leftovers, modifierPredicate);
        }
    }
}

